/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRoleDefinition;
import filenet.vw.api.VWRollbackInstruction;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWRuleSetDefinition;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWFEInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkBasketColumnDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWWorkBasketFilterDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXLIFFHandler;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageElement;
import filenet.vw.toolkit.utils.uicontrols.language.VWLanguageList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWCreateXliffDialog
extends VWModalDialog
implements ActionListener {
    private JTextField m_sourceLanguageElementTextField = null;
    private JComboBox m_targetLocaleComboBox = null;
    private JTextField m_fileNameTextField = null;
    private JButton m_browseButton = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWConfigRegionNode m_regionNode = null;
    private VWXLIFFHandler m_xliffHandler = null;
    private VWLanguageList m_languageList = null;
    private VWLanguageElement m_sourceLanguageElement = null;
    private FileDialog m_localSaveDialog = null;
    private boolean m_bCheckFileExistence = true;

    public VWCreateXliffDialog(Frame parentFrame) {
        super(parentFrame);
        try {
            this.m_languageList = new VWLanguageList();
            this.setTitle(VWResource.CreateXliffFile);
            VWAccessibilityHelper.setAccessibility(this, null, VWResource.CreateXliffFile, VWResource.CreateXliffFile);
            Dimension dim = VWStringUtils.stringToDimension("555,140");
            if (dim == null) {
                dim = new Dimension(500, 125);
            }
            this.setSize(dim);
            this.createControls();
            this.initControls(parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void initialize(VWConfigRegionNode regionNode) {
        try {
            this.m_regionNode = regionNode;
            this.m_xliffHandler = new VWXLIFFHandler(regionNode.getRegionID());
            Locale serverLocale = regionNode.getSession().fetchServerLocale();
            if (serverLocale == null) {
                VWMessageDialog.showOptionDialog(this, VWResource.InvalidServerLocale, 2);
                serverLocale = Locale.ENGLISH;
            }
            this.m_sourceLanguageElement = this.m_languageList.getElementFromCode(serverLocale.getLanguage());
            this.m_sourceLanguageElementTextField.setText(this.m_sourceLanguageElement.toString());
            this.m_targetLocaleComboBox.setSelectedIndex(this.m_targetLocaleComboBox.getSelectedIndex());
            this.m_bCheckFileExistence = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_targetLocaleComboBox)) {
                Locale locale = this.getTargetLocale();
                String fileName = this.m_xliffHandler.getDefaultFileName(locale, true);
                this.m_fileNameTextField.setText(fileName);
                this.m_fileNameTextField.setToolTipText(this.m_localSaveDialog.getDirectory());
                this.m_localSaveDialog.setFile(fileName);
                this.m_bCheckFileExistence = true;
            } else if (event.getSource().equals(this.m_browseButton)) {
                this.m_localSaveDialog.setVisible(true);
                String fileName = this.m_localSaveDialog.getFile();
                if (fileName != null) {
                    this.m_fileNameTextField.setText(fileName);
                    this.m_fileNameTextField.setToolTipText(this.m_localSaveDialog.getDirectory());
                    this.m_bCheckFileExistence = false;
                }
            } else if (event.getSource().equals(this.m_okButton)) {
                if (!this.writeXliffFile()) {
                    return;
                }
                this.m_nExitStatus = 0;
                this.setVisible(false);
            } else if (event.getSource().equals(this.m_cancelButton)) {
                this.m_nExitStatus = 1;
                this.setVisible(false);
            } else if (event.getSource().equals(this.m_helpButton)) {
                VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc078.htm");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls() {
        try {
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.anchor = 21;
            JPanel topPanel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(VWResource.SourceLanguage);
            topPanel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.SourceLanguage, VWResource.SourceLanguage);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.gridwidth = 1;
            this.m_sourceLanguageElementTextField = new JTextField();
            this.m_sourceLanguageElementTextField.setEditable(false);
            topPanel.add((Component)this.m_sourceLanguageElementTextField, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_sourceLanguageElementTextField, this, VWResource.SourceLanguage, VWResource.SourceLanguage);
            VWAccessibilityHelper.setLabelFor(label, this.m_sourceLanguageElementTextField);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 1;
            label = new JLabel(VWResource.TargetLanguage);
            topPanel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.TargetLanguage, VWResource.TargetLanguage);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.gridwidth = 0;
            this.m_targetLocaleComboBox = new JComboBox();
            this.m_targetLocaleComboBox.setRenderer(new VWLabelListCellRenderer());
            topPanel.add((Component)this.m_targetLocaleComboBox, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_targetLocaleComboBox, this, VWResource.TargetLanguage, VWResource.TargetLanguage);
            VWAccessibilityHelper.setLabelFor(label, this.m_targetLocaleComboBox);
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.weightx = 1.0;
            mainPanel.add((Component)topPanel, gbCons);
            JPanel secondPanel = new JPanel(new GridBagLayout());
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 1;
            label = new JLabel(VWResource.FileName);
            secondPanel.add((Component)label, gbCons);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.FileName, VWResource.FileName);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 2;
            this.m_fileNameTextField = new JTextField();
            this.m_fileNameTextField.setEditable(false);
            secondPanel.add((Component)this.m_fileNameTextField, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_fileNameTextField, this, VWResource.FileName, VWResource.FileName);
            VWAccessibilityHelper.setLabelFor(label, this.m_fileNameTextField);
            gbCons.gridx += 2;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 0;
            gbCons.anchor = 10;
            this.m_browseButton = new JButton(VWResource.Browse);
            this.m_browseButton.addActionListener(this);
            secondPanel.add((Component)this.m_browseButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_browseButton, this, VWResource.Browse, VWResource.Browse);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            mainPanel.add((Component)secondPanel, gbCons);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.OK);
            this.m_okButton.setSelected(true);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.OK, VWResource.OK);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.Cancel, VWResource.Cancel);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void initControls(Frame parentFrame) {
        try {
            if (this.m_localSaveDialog == null) {
                this.m_localSaveDialog = new FileDialog(parentFrame, VWResource.SaveDialogTitle, 1);
            }
            this.m_localSaveDialog.setDirectory(System.getProperty("user.dir") + File.separator);
            DefaultComboBoxModel<VWLanguageElement> comboBoxModel = new DefaultComboBoxModel<VWLanguageElement>(this.m_languageList.getLanguageList());
            this.m_targetLocaleComboBox.setModel(comboBoxModel);
            this.m_targetLocaleComboBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private Locale getTargetLocale() {
        VWLanguageElement langElement = (VWLanguageElement)this.m_targetLocaleComboBox.getSelectedItem();
        return langElement.getLocale();
    }

    private String getFilePath() {
        if (this.m_localSaveDialog.getDirectory() != null) {
            return this.m_localSaveDialog.getDirectory() + this.m_localSaveDialog.getFile();
        }
        return this.m_localSaveDialog.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeXliffFile() {
        boolean bl;
        String filePath;
        block7: {
            int nResult;
            File outFile;
            filePath = this.getFilePath();
            if (!this.m_bCheckFileExistence || !(outFile = new File(filePath)).exists() || (nResult = VWMessageDialog.showConfirmDialog(this, VWResource.s_fileExists, VWResource.Replace, 3)) != 2) break block7;
            boolean bl2 = false;
            Object var10_8 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            return bl2;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            HashSet list = new HashSet();
            VWSystemConfiguration sysConfig = this.m_regionNode.getSystemConfiguration();
            this.retrieveStringsFromSystemConfiguration(sysConfig, list);
            VWSession vwSession = this.m_regionNode.getSession();
            String[] workClassNames = vwSession.fetchWorkClassNames(true);
            if (workClassNames != null) {
                for (int i = 0; i < workClassNames.length; ++i) {
                    this.retrieveStringsFromWorkClass(vwSession, workClassNames[i], list);
                }
            }
            String[] names = new String[list.size()];
            names = list.toArray(names);
            Locale targetLocale = this.getTargetLocale();
            this.m_xliffHandler.writeStringsToFile(this.m_sourceLanguageElement.getLocale(), names, targetLocale, filePath);
            bl = true;
            Object var10_9 = null;
        }
        catch (Exception ex) {
            try {
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_error, 0);
                VWDebug.logException(ex);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                throw throwable;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return bl;
    }

    private void retrieveStringsFromSystemConfiguration(VWSystemConfiguration sysConfig, HashSet list) {
        try {
            VWApplicationSpaceDefinition[] appSpaceDefs;
            VWStepProcessorInfoDefinition[] stepProcInfoDefs;
            VWRosterDefinition[] rosterDefs;
            VWQueueDefinition[] queueDefs;
            VWLogDefinition[] logDefs = sysConfig.getLogDefinitions();
            if (logDefs != null) {
                VWExposedFieldDefinition[] systemFields = VWLogDefinition.optionalSystemFields();
                if (systemFields != null) {
                    for (int j = 0; j < systemFields.length; ++j) {
                        list.add(systemFields[j].getName());
                    }
                }
                for (int i = 0; i < logDefs.length; ++i) {
                    VWIndexDefinition[] indexDefs;
                    VWExposedFieldDefinition[] exposedFields;
                    list.add(logDefs[i].getName());
                    if (logDefs[i].getDescription() != null) {
                        list.add(logDefs[i].getDescription());
                    }
                    if ((exposedFields = logDefs[i].getFields()) != null) {
                        for (int j = 0; j < exposedFields.length; ++j) {
                            list.add(exposedFields[j].getName());
                        }
                    }
                    if ((indexDefs = logDefs[i].getIndexes()) == null) continue;
                    for (int j = 0; j < indexDefs.length; ++j) {
                        list.add(indexDefs[j].getName());
                    }
                }
            }
            if ((queueDefs = sysConfig.getQueueDefinitions()) != null) {
                list.add("Conductor");
                list.add("WSRequest");
                list.add("WSRequest(0)");
                VWExposedFieldDefinition[] systemFields = VWQueueDefinition.optionalSystemFields();
                if (systemFields != null) {
                    for (int j = 0; j < systemFields.length; ++j) {
                        list.add(systemFields[j].getName());
                    }
                }
                for (int i = 0; i < queueDefs.length; ++i) {
                    VWWorkBasketDefinition[] workBasketDefs;
                    VWOperationDefinition[] operationDefs;
                    VWIndexDefinition[] indexDefs;
                    VWExposedFieldDefinition[] exposedFields;
                    list.add(queueDefs[i].getName());
                    if (queueDefs[i].getQueueType() == 2) {
                        list.add(queueDefs[i].getName() + "(0)");
                    }
                    if (queueDefs[i].getDescription() != null) {
                        list.add(queueDefs[i].getDescription());
                    }
                    if ((exposedFields = queueDefs[i].getFields()) != null) {
                        for (int j = 0; j < exposedFields.length; ++j) {
                            list.add(exposedFields[j].getName());
                        }
                    }
                    if ((indexDefs = queueDefs[i].getIndexes()) != null) {
                        for (int j = 0; j < indexDefs.length; ++j) {
                            list.add(indexDefs[j].getName());
                        }
                    }
                    if ((operationDefs = queueDefs[i].getOperations()) != null) {
                        for (int j = 0; j < operationDefs.length; ++j) {
                            VWParameterDefinition[] parameterDefs;
                            list.add(operationDefs[j].getName());
                            if (operationDefs[j].getDescription() != null) {
                                list.add(operationDefs[j].getDescription());
                            }
                            if ((parameterDefs = operationDefs[j].getParameterDefinitions()) == null) continue;
                            for (int k = 0; k < parameterDefs.length; ++k) {
                                list.add(parameterDefs[k].getName());
                                if (parameterDefs[k].getDescription() == null) continue;
                                list.add(parameterDefs[k].getDescription());
                            }
                        }
                    }
                    if ((workBasketDefs = queueDefs[i].getWorkBasketDefinitions()) == null) continue;
                    for (int j = 0; j < workBasketDefs.length; ++j) {
                        VWWorkBasketFilterDefinition[] filterDefs;
                        VWWorkBasketColumnDefinition[] columnDefs;
                        list.add(workBasketDefs[j].getName());
                        if (workBasketDefs[j].getDescription() != null) {
                            list.add(workBasketDefs[j].getDescription());
                        }
                        if ((columnDefs = workBasketDefs[j].getWorkBasketColumnDefinitions()) != null) {
                            for (int k = 0; k < columnDefs.length; ++k) {
                                list.add(columnDefs[k].getName());
                                if (columnDefs[k].getPrompt() == null) continue;
                                list.add(columnDefs[k].getPrompt());
                            }
                        }
                        if ((filterDefs = workBasketDefs[j].getWorkBasketFilterDefinitions()) == null) continue;
                        for (int k = 0; k < filterDefs.length; ++k) {
                            list.add(filterDefs[k].getName());
                            if (filterDefs[k].getPrompt() != null) {
                                list.add(filterDefs[k].getPrompt());
                            }
                            if (filterDefs[k].getDescription() == null) continue;
                            list.add(filterDefs[k].getDescription());
                        }
                    }
                }
            }
            if ((rosterDefs = sysConfig.getRosterDefinitions()) != null) {
                VWExposedFieldDefinition[] systemFields = VWRosterDefinition.optionalSystemFields();
                if (systemFields != null) {
                    for (int j = 0; j < systemFields.length; ++j) {
                        list.add(systemFields[j].getName());
                    }
                }
                for (int i = 0; i < rosterDefs.length; ++i) {
                    VWIndexDefinition[] indexDefs;
                    VWExposedFieldDefinition[] exposedFields;
                    list.add(rosterDefs[i].getName());
                    if (rosterDefs[i].getDescription() != null) {
                        list.add(rosterDefs[i].getDescription());
                    }
                    if ((exposedFields = rosterDefs[i].getFields()) != null) {
                        for (int j = 0; j < exposedFields.length; ++j) {
                            list.add(exposedFields[j].getName());
                        }
                    }
                    if ((indexDefs = rosterDefs[i].getIndexes()) == null) continue;
                    for (int j = 0; j < indexDefs.length; ++j) {
                        list.add(indexDefs[j].getName());
                    }
                }
            }
            if ((stepProcInfoDefs = sysConfig.getStepProcessorInfoDefinitions()) != null) {
                for (int i = 0; i < stepProcInfoDefs.length; ++i) {
                    list.add(stepProcInfoDefs[i].getName());
                }
            }
            if ((appSpaceDefs = sysConfig.getApplicationSpaceDefinitions()) != null) {
                for (int i = 0; i < appSpaceDefs.length; ++i) {
                    VWRoleDefinition[] roleDefs;
                    list.add(appSpaceDefs[i].getName());
                    if (appSpaceDefs[i].getDescription() != null) {
                        list.add(appSpaceDefs[i].getDescription());
                    }
                    if ((roleDefs = appSpaceDefs[i].getRoleDefinitions()) == null) continue;
                    for (int j = 0; j < roleDefs.length; ++j) {
                        list.add(roleDefs[j].getName());
                        if (roleDefs[i].getDescription() == null) continue;
                        list.add(roleDefs[i].getDescription());
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void retrieveStringsFromWorkClass(VWSession vwSession, String workClassName, HashSet list) {
        block45: {
            try {
                VWSchema[] schemas;
                VWRuleSetDefinition[] ruleSetDefs;
                VWPartnerLinkDefinition[] pLinkDefs;
                VWMilestoneDefinition[] milestoneDefs;
                VWWorkflowSignature wfSignature = vwSession.fetchWorkflowSignature(workClassName);
                if (wfSignature != null) {
                    VWFieldDefinition[] fieldDefs;
                    Object value;
                    list.add(wfSignature.getName());
                    VWFieldDefinition subjectFieldDef = wfSignature.findField("F_Subject");
                    if (subjectFieldDef != null && (value = subjectFieldDef.getValue()) != null) {
                        String subject = (String)value;
                        if (value != null && subject.length() > 0 && subject.charAt(0) == '\"') {
                            subject = subject.substring(1, subject.length() - 1);
                        }
                        list.add(subject);
                    }
                    if (wfSignature.getDescription() != null) {
                        list.add(wfSignature.getDescription());
                    }
                    if ((fieldDefs = wfSignature.getFieldDefinitions()) != null) {
                        for (int i = 0; i < fieldDefs.length; ++i) {
                            list.add(fieldDefs[i].getName());
                        }
                    }
                    list.add("F_WsStatus");
                }
                list.add("Tracker Step");
                VWWorkflowDefinition wfDef = vwSession.fetchWorkflowDefinition(-1, workClassName, true);
                if (wfDef == null) break block45;
                VWMapDefinition[] mapDefs = wfDef.getMaps();
                if (mapDefs != null) {
                    for (int i = 0; i < mapDefs.length; ++i) {
                        VWMapNode[] mapNodes;
                        list.add(mapDefs[i].getName());
                        if (mapDefs[i].getDescription() != null) {
                            list.add(mapDefs[i].getDescription());
                        }
                        if ((mapNodes = mapDefs[i].getSteps()) == null) continue;
                        for (int j = 0; j < mapNodes.length; ++j) {
                            VWRouteDefinition[] routeDefs;
                            int k;
                            VWMapNode stepDef;
                            if (mapNodes[j].getName() != null) {
                                list.add(mapNodes[j].getName());
                            }
                            if (mapNodes[j].getDescription() != null) {
                                list.add(mapNodes[j].getDescription());
                            }
                            if (mapNodes[j] instanceof VWCompoundStepDefinition) {
                                stepDef = (VWCompoundStepDefinition)mapNodes[j];
                                VWInstructionDefinition[] instructionDefs = ((VWCompoundStepDefinition)stepDef).getInstructions();
                                if (instructionDefs != null) {
                                    for (k = 0; k < instructionDefs.length; ++k) {
                                        VWWebServiceParameterDefinition[] wsParamDefs;
                                        if (instructionDefs[k] instanceof VWInvokeInstruction) {
                                            int x;
                                            VWWebServiceParameterDefinition[] wsParamDefs2;
                                            VWInvokeInstruction invokeInstr = (VWInvokeInstruction)instructionDefs[k];
                                            VWFaultDefinition[] faultDefs = invokeInstr.getFaults();
                                            if (faultDefs != null) {
                                                for (int x2 = 0; x2 < faultDefs.length; ++x2) {
                                                    list.add(faultDefs[x2].getName());
                                                }
                                            }
                                            if ((wsParamDefs2 = invokeInstr.getInComingParameterDefinitions()) != null) {
                                                for (x = 0; x < wsParamDefs2.length; ++x) {
                                                    list.add(wsParamDefs2[x].getName());
                                                }
                                            }
                                            if ((wsParamDefs2 = invokeInstr.getOutGoingParameterDefinitions()) == null) continue;
                                            for (x = 0; x < wsParamDefs2.length; ++x) {
                                                list.add(wsParamDefs2[x].getName());
                                            }
                                            continue;
                                        }
                                        if (instructionDefs[k] instanceof VWReceiveInstruction) {
                                            VWReceiveInstruction receiveInstr = (VWReceiveInstruction)instructionDefs[k];
                                            wsParamDefs = receiveInstr.getParameterDefinitions();
                                            if (wsParamDefs == null) continue;
                                            for (int x = 0; x < wsParamDefs.length; ++x) {
                                                list.add(wsParamDefs[x].getName());
                                            }
                                            continue;
                                        }
                                        if (instructionDefs[k] instanceof VWReplyInstruction) {
                                            VWReplyInstruction replyInstr = (VWReplyInstruction)instructionDefs[k];
                                            wsParamDefs = replyInstr.getParameterDefinitions();
                                            if (wsParamDefs == null) continue;
                                            for (int x = 0; x < wsParamDefs.length; ++x) {
                                                list.add(wsParamDefs[x].getName());
                                            }
                                            continue;
                                        }
                                        if (instructionDefs[k] instanceof VWRollbackInstruction) {
                                            VWRollbackInstruction rollbackInstr = (VWRollbackInstruction)instructionDefs[k];
                                            continue;
                                        }
                                        if (instructionDefs[k] instanceof VWSimpleInstruction) {
                                            VWSimpleInstruction simpleInstr = (VWSimpleInstruction)instructionDefs[k];
                                            continue;
                                        }
                                        if (!(instructionDefs[k] instanceof VWWFEInstruction)) continue;
                                        VWWFEInstruction wfeInstr = (VWWFEInstruction)instructionDefs[k];
                                    }
                                }
                            } else if (mapNodes[j] instanceof VWStepDefinition) {
                                String[] responses;
                                stepDef = (VWStepDefinition)mapNodes[j];
                                VWParameterDefinition[] paramDefs = ((VWStepDefinition)stepDef).getParameterDefinitions();
                                if (paramDefs != null) {
                                    for (k = 0; k < paramDefs.length; ++k) {
                                        list.add(paramDefs[k].getName());
                                        if (paramDefs[k].getDescription() == null) continue;
                                        list.add(paramDefs[k].getDescription());
                                    }
                                }
                                if ((responses = ((VWStepDefinition)stepDef).getResponses()) != null) {
                                    for (int k2 = 0; k2 < responses.length; ++k2) {
                                        list.add(responses[k2]);
                                    }
                                }
                            }
                            if ((routeDefs = mapNodes[j].getNextRoutes()) == null) continue;
                            for (int k3 = 0; k3 < routeDefs.length; ++k3) {
                                if (routeDefs[k3].getName() == null) continue;
                                list.add(routeDefs[k3].getName());
                            }
                        }
                    }
                }
                if ((milestoneDefs = wfDef.getMilestones()) != null) {
                    for (int i = 0; i < milestoneDefs.length; ++i) {
                        list.add(milestoneDefs[i].getName());
                    }
                }
                if ((pLinkDefs = wfDef.getPartnerLinks()) != null) {
                    for (int i = 0; i < pLinkDefs.length; ++i) {
                        list.add(pLinkDefs[i].getName());
                        if (pLinkDefs[i].getMyPortType() != null) {
                            list.add("F_MyEndPointRef" + pLinkDefs[i].getName());
                        }
                        if (pLinkDefs[i].getPartnerEndPoint() == null) continue;
                        list.add("F_EndPointRef" + pLinkDefs[i].getName());
                    }
                }
                if ((ruleSetDefs = wfDef.getRuleSets()) != null) {
                    for (int i = 0; i < ruleSetDefs.length; ++i) {
                        list.add(ruleSetDefs[i].getName());
                    }
                }
                if ((schemas = wfDef.getSchemas()) != null) {
                    for (int i = 0; i < schemas.length; ++i) {
                        list.add(schemas[i].getName());
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }
}

